<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página com Balão</title>
    <!-- Integração com Bootstrap -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .balao {
            position: fixed;
            top: 15%;
            left: 20px;
            background-color: rgba(0, 0, 0, 0.7);
            color: red; /* Cor padrão */
            padding: 0px;
            border-radius: 10px;
            z-index: 1000;
            max-width: 90%;
            display: none;
            font-size: 30px;
            line-height: 1.6;
        }
        .iframe-container {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
        }
        iframe {
            width: 100%;
            height: 100%;
            border: none;
        }
    </style>
</head>
<body>
    <div class="balao" id="balao"></div>
    <div class="iframe-container">
        <iframe src="https://vuauto.wctv.fun/wc/api/autocima.php"></iframe>
    </div>

    <!-- Integração com jQuery (necessário para mostrar o balão) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            // Função para exibir o balão com os dados do PHP
            function exibirBalao(mensagem, cor) {
                var balao = $('#balao');
                balao.html('<strong style="color: ' + cor + '">' + mensagem + '</strong>');
                balao.fadeIn();
            }
            
            <?php
                // Define o caminho para o arquivo de texto
                $file_path = "../ad_descriptions.txt";

                // Lê o conteúdo do arquivo de texto
                $content = file_get_contents($file_path);

                // Divide o conteúdo em mensagem e cor
                $lines = explode("\n", $content);
                
                if(count($lines) >= 2) {
                    $mensagem = trim($lines[0]);
                    $cor = trim($lines[1]);
                    
                    // Se a cor não estiver vazia, aplique-a no balão
                    if (!empty($cor)) {
                        echo 'exibirBalao("' . $mensagem . '", "' . $cor . '");';
                    } else {
                        // Caso a cor não esteja definida, use a cor padrão
                        echo 'exibirBalao("' . $mensagem . '", "red");';
                    }
                } else {
                    // Se o arquivo não contém informações suficientes, exiba um aviso
                    echo 'console.error("O arquivo de descrições não contém informações suficientes.");';
                }
            ?>
        });
    </script>
</body>
</html>
