<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Carrusel de Posters de Películas TMDB - Optimizado</title>
    <style>
        body, html {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            background-color: #141414;
            font-family: Arial, sans-serif;
        }
        .carousel-container {
            width: 100%;
            height: 100%;
            overflow: hidden;
            position: relative;
        }
        .carousel {
            display: flex;
            height: 100%;
            position: absolute;
            left: 0;
        }
        .movie-poster {
            flex: 0 0 auto;
            height: 100%;
            width: auto;
            margin-right: 10px;
        }
        .movie-poster img {
            height: 100%;
            width: auto;
            max-width: none;
        }
    </style>
</head>
<body>
    <div class="carousel-container">
        <div id="carousel" class="carousel"></div>
    </div>
    <script>
        const API_KEY = '54a47dfd36406757c9a6b7a0e3fd9cdc';
        const BASE_URL = 'https://api.themoviedb.org/3';
        const IMG_BASE_URL = 'https://image.tmdb.org/t/p/w342'; // Cambiado a w342 para posters más pequeños
        const POSTER_LIMIT = 20; // Limitar el número de pósters

        async function fetchNowPlayingMovies() {
            try {
                const response = await fetch(`${BASE_URL}/movie/now_playing?api_key=${API_KEY}&language=en-US`);
                const data = await response.json();
                return data.results.slice(0, POSTER_LIMIT);
            } catch (error) {
                console.error('Error fetching movies:', error);
                return [];
            }
        }

        function createMoviePoster(movie) {
            const posterElement = document.createElement('div');
            posterElement.className = 'movie-poster';
            posterElement.innerHTML = `<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=" data-src="${IMG_BASE_URL}${movie.poster_path}" alt="${movie.title}">`;
            return posterElement;
        }

        function lazyLoadImage(img) {
            const observer = new IntersectionObserver(entries => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const image = entry.target;
                        image.src = image.dataset.src;
                        observer.unobserve(image);
                    }
                });
            });
            observer.observe(img);
        }

        async function initializeCarousel() {
            const carousel = document.getElementById('carousel');
            const movies = await fetchNowPlayingMovies();
            
            movies.forEach(movie => {
                const posterElement = createMoviePoster(movie);
                carousel.appendChild(posterElement);
                lazyLoadImage(posterElement.querySelector('img'));
            });

            // Duplicar los primeros posters para crear un efecto circular
            for (let i = 0; i < 5 && i < movies.length; i++) {
                const posterElement = createMoviePoster(movies[i]);
                carousel.appendChild(posterElement);
                lazyLoadImage(posterElement.querySelector('img'));
            }

            let position = 0;
            const speed = 0.5; // Velocidad reducida

            function moveCarousel() {
                position -= speed;
                const firstPoster = carousel.children[0];
                const posterWidth = firstPoster.offsetWidth + 10; // 10 es el margen
                if (position <= -posterWidth) {
                    position += posterWidth;
                    carousel.appendChild(firstPoster);
                }
                carousel.style.transform = `translateX(${position}px)`;
                requestAnimationFrame(moveCarousel);
            }

            moveCarousel();
        }

        document.addEventListener('DOMContentLoaded', initializeCarousel);
    </script>
</body>
</html>