<?php
@session_start();

$db = new SQLite3('./api/.db.db');
$db->exec("CREATE TABLE IF NOT EXISTS users(id INTEGER PRIMARY KEY,username TEXT ,password TEXT)");

$log_check = $db->query("SELECT * FROM users WHERE id='1'");
$roe = $log_check->fetchArray();
$loggedinuser = @$roe['username'];

$rows = $db->query("SELECT COUNT(*) as count FROM users");
$row = $rows->fetchArray();
$numRows = $row['count'];
if ($numRows == 0){
    $db->exec("INSERT INTO users(id ,username, password) VALUES('1' ,'admin', 'admin')");
    $db->close();
}

if (isset($_POST["login"])){
    if(!$db){
        echo $db->lastErrorMsg();
    } else {
        $sql ='SELECT * from users where username="'.$_POST["username"].'";';
        $ret = $db->query($sql);
        while($row = $ret->fetchArray() ){
            $id=$row['id'];
            $username=$row['username'];
            $password=$row['password'];
        }
        if ($id!=""){
            if ($password==$_POST["password"]){
                session_regenerate_id();
                $_SESSION['loggedin'] = TRUE;
                $_SESSION['name'] = $_POST['username'];
                header("Location: dns.php");
                exit;
            } else {
                $error = "Contraseña incorrecta";
            }
        } else {
            $error = "Usuario no encontrado";
        }
    }
    $db->close();
}

function getMoviesFromEndpoint($api_key, $pages = 10) {
    $cache_file = 'movies_cache.json';
    $cache_time = 3600; // 1 hora

    if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_time)) {
        return json_decode(file_get_contents($cache_file), true);
    }

    $movies = [];
    for ($page = 1; $page <= $pages; $page++) {
        $url = "https://api.themoviedb.org/3/movie/now_playing?api_key={$api_key}&language=en-US&page={$page}";
        $response = file_get_contents($url);
        $data = json_decode($response, true);
        if (isset($data['results']) && is_array($data['results'])) {
            $movies = array_merge($movies, $data['results']);
        }
    }
    
    $movies = array_filter($movies, function($movie) {
        return isset($movie['poster_path']) && $movie['poster_path'] !== null;
    });

    file_put_contents($cache_file, json_encode($movies));
    return $movies;
}

$api_key = '54a47dfd36406757c9a6b7a0e3fd9cdc';
$movies = getMoviesFromEndpoint($api_key);
$total_movies = count($movies);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAuncherTv</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            overflow: hidden;
            background-color: #000;
        }
        .carousel-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }
        .carousel-content {
            display: flex;
            flex-direction: column;
            transition: transform 0.5s linear;
        }
        .poster-row {
            display: flex;
            justify-content: space-around;
            width: 100%;
            flex-shrink: 0;
            margin-bottom: 10px;
        }
        .poster {
            width: calc(20% - 10px);
            position: relative;
            overflow: hidden;
            aspect-ratio: 2/3;
            cursor: pointer;
            transition: transform 0.3s ease;
        }
        .poster:hover {
            transform: scale(1.05);
            z-index: 10;
        }
        .poster img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }
        .poster-title {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(0,0,0,0.7);
            color: white;
            padding: 5px;
            text-align: center;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        .poster:hover .poster-title {
            opacity: 1;
        }
        .login-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            pointer-events: none;
        }
        .login-form {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            width: 400px;
            box-shadow: 0 0 20px rgba(0,0,0,0.3);
            pointer-events: auto;
        }
        .login-logo {
            display: block;
            margin: 0 auto 20px;
            width: 300px;
            height: auto;
        }
    </style>
</head>
<body>
    <div class="carousel-container">
        <div class="carousel-content">
            <?php 
            $rows = ceil($total_movies / 5);
            for ($i = 0; $i < $rows; $i++) {
                echo '<div class="poster-row">';
                for ($j = 0; $j < 5; $j++) {
                    $index = $i * 5 + $j;
                    if ($index < $total_movies) {
                        $movie = $movies[$index];
                        echo '<a href="https://www.themoviedb.org/movie/' . $movie['id'] . '" target="_blank" class="poster">';
                        echo '<img src="https://image.tmdb.org/t/p/w500' . $movie['poster_path'] . '" alt="' . $movie['title'] . '" loading="lazy">';
                        echo '<div class="poster-title">' . $movie['title'] . '</div>';
                        echo '</a>';
                    }
                }
                echo '</div>';
            }
            ?>
        </div>
    </div>

    <div class="login-overlay">
        <div class="login-form">
            <img src="https://iptvrebrandmx.com/assets/images/logo-dark.png?text=Logo" alt="Logo" class="login-logo">
            <h4 class="text-center mb-4">LauncherTV</h4>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            <form method="post">
                <div class="form-group">
                    <input type="text" class="form-control" name="username" placeholder="Username" required>
                </div>
                <div class="form-group">
                    <input type="password" class="form-control" name="password" placeholder="Password" required>
                </div>
                <button type="submit" name="login" class="btn btn-primary btn-block">Login</button>
            </form>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const container = document.querySelector('.carousel-container');
        const content = document.querySelector('.carousel-content');
        let position = 0;
        let direction = 1; // 1 para abajo, -1 para arriba
        let animationFrame;

        function animate() {
            const containerHeight = container.offsetHeight;
            const contentHeight = content.offsetHeight;

            position += direction;
            if (position <= 0 || position >= contentHeight - containerHeight) {
                direction *= -1;
            }

            content.style.transform = `translateY(-${position}px)`;

            animationFrame = requestAnimationFrame(animate);
        }

        animationFrame = requestAnimationFrame(animate);

        window.addEventListener('resize', () => {
            cancelAnimationFrame(animationFrame);
            position = 0;
            animationFrame = requestAnimationFrame(animate);
        });
    });
    </script>

    <?php include ('includes/footer.php');?>
</body>
</html>